/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.RunnableAction;
import com.badlogic.gdx.utils.Array;
import com.skloch.game.GameScreen;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;

public class EventManager {
    private final GameScreen game;
    public HashMap<String, Integer> activityEnergies;
    private final HashMap<String, String> objectInteractions;
    private final Array<String> talkTopics;

    public EventManager(GameScreen game) {
        this.game = game;
        this.activityEnergies = new HashMap();
        this.activityEnergies.put("studying", 10);
        this.activityEnergies.put("meet_friends", 10);
        this.activityEnergies.put("eating", 10);
        this.objectInteractions = new HashMap();
        this.objectInteractions.put("chest", "Open the chest?");
        this.objectInteractions.put("comp_sci", "Study in the Computer Science building?");
        this.objectInteractions.put("piazza", "Meet your friends at the Piazza?");
        this.objectInteractions.put("accomodation", "Go to sleep for the night?\nYour alarm is set for 8am.");
        this.objectInteractions.put("rch", null);
        this.objectInteractions.put("tree", "Speak to the tree?");
        String[] topics = new String[]{"Dogs", "Cats", "Exams", "Celebrities", "Flatmates", "Video games", "Sports", "Food", "Fashion"};
        this.talkTopics = new Array<String>(topics);
    }

    public void event(String eventKey) {
        String[] args = eventKey.split("-");
        if (args[0] == "fadefromblack") {
            this.fadeFromBlack();
        } else if (args[0] == "fadetoblack") {
            this.fadeToBlack();
        } else if (args[0] == "gameover") {
            this.game.GameOver();
        }
        switch (args[0]) {
            case "tree": {
                this.treeEvent();
                break;
            }
            case "chest": {
                this.chestEvent();
                break;
            }
            case "piazza": {
                this.piazzaEvent(args);
                break;
            }
            case "comp_sci": {
                this.compSciEvent(args);
                break;
            }
            case "rch": {
                this.ronCookeEvent(args);
                break;
            }
            case "accomodation": {
                this.accomEvent(args);
                break;
            }
            case "exit": {
                this.game.dialogueBox.hide();
                break;
            }
            default: {
                this.objectEvent(eventKey);
            }
        }
    }

    public String getObjectInteraction(String key) {
        if (key.equals("rch")) {
            return String.format("Eat %s at the Ron Cooke Hub?", this.game.getMeal());
        }
        return this.objectInteractions.get(key);
    }

    public boolean hasCustomObjectInteraction(String key) {
        return this.objectInteractions.containsKey(key);
    }

    public void treeEvent() {
        this.game.dialogueBox.hideSelectBox();
        this.game.dialogueBox.setText("The tree doesn't say anything back.");
    }

    public void chestEvent() {
        this.game.dialogueBox.hideSelectBox();
        this.game.dialogueBox.setText("Wow! This chest is full of so many magical items! I wonder how they will help you out on your journey! Boy, this is an awfully long piece of text, I wonder if someone is testing something?\n...\n...\n...\nHow cool!");
    }

    public void objectEvent(String object) {
        this.game.dialogueBox.hideSelectBox();
        this.game.dialogueBox.setText("This is a " + object + "!");
    }

    public void piazzaEvent(String[] args) {
        if (this.game.getSeconds() > 480.0f) {
            int energyCost = this.activityEnergies.get("meet_friends");
            if (this.game.getEnergy() < energyCost) {
                this.game.dialogueBox.setText("You are too tired to meet your friends right now!");
            } else if (args.length == 1) {
                String[] topics = this.randomTopics(3);
                this.game.dialogueBox.setText("What do you want to chat about?");
                this.game.dialogueBox.getSelectBox().setOptions(topics, new String[]{"piazza-" + topics[0], "piazza-" + topics[1], "piazza-" + topics[2]});
            } else {
                int hours = ThreadLocalRandom.current().nextInt(1, 4);
                this.game.dialogueBox.setText(String.format("You talked about %s for %d hours!", args[1].toLowerCase(), hours));
                this.game.decreaseEnergy(energyCost * hours);
                this.game.passTime(hours * 60);
                this.game.addRecreationalHours(hours);
            }
        } else {
            this.game.dialogueBox.setText("It's too early in the morning to meet your friends, go to bed!");
        }
    }

    private String[] randomTopics(int amount) {
        Array<String> topics = new Array<String>(amount);
        for (int i = 0; i < amount; ++i) {
            String choice = this.talkTopics.random();
            if (!topics.contains(choice, false)) {
                topics.add(choice);
                continue;
            }
            --i;
        }
        return topics.toArray(String.class);
    }

    public void compSciEvent(String[] args) {
        if (this.game.getSeconds() > 480.0f) {
            int energyCost = this.activityEnergies.get("studying");
            if (this.game.getEnergy() < energyCost) {
                this.game.dialogueBox.hideSelectBox();
                this.game.dialogueBox.setText("You are too tired to study right now!");
            } else if (args.length == 1) {
                this.game.dialogueBox.setText("Study for how long?");
                this.game.dialogueBox.getSelectBox().setOptions(new String[]{"2 Hours (20)", "3 Hours (30)", "4 Hours (40)"}, new String[]{"comp_sci-2", "comp_sci-3", "comp_sci-4"});
            } else {
                int hours = Integer.parseInt(args[1]);
                if (this.game.getEnergy() < hours * energyCost) {
                    this.game.dialogueBox.setText("You don't have the energy to study for this long!");
                } else {
                    this.game.dialogueBox.setText(String.format("You studied for %s hours!\nYou lost %d energy", args[1], hours * energyCost));
                    this.game.decreaseEnergy(energyCost * hours);
                    this.game.addStudyHours(hours);
                    this.game.passTime(hours * 60);
                }
            }
        } else {
            this.game.dialogueBox.setText("It's too early in the morning to study, go to bed!");
        }
    }

    public void ronCookeEvent(String[] args) {
        if (this.game.getSeconds() > 480.0f) {
            int energyCost = this.activityEnergies.get("eating");
            if (this.game.getEnergy() < energyCost) {
                this.game.dialogueBox.setText("You are too tired to eat right now!");
            } else {
                this.game.dialogueBox.setText(String.format("You took an hour to eat %s at the Ron Cooke Hub!\nYou lost %d energy!", this.game.getMeal(), energyCost));
                this.game.decreaseEnergy(energyCost);
                this.game.passTime(60.0f);
            }
        } else {
            this.game.dialogueBox.setText("It's too early in the morning to eat food, go to bed!");
        }
    }

    public void accomEvent(String[] args) {
        this.game.setSleeping(true);
        this.game.dialogueBox.hide();
        final float secondsSlept = this.game.getSeconds() < 480.0f ? 480.0f - this.game.getSeconds() : 1920.0f - this.game.getSeconds();
        final int hoursSlept = Math.round(secondsSlept / 60.0f);
        RunnableAction setTextAction = new RunnableAction();
        setTextAction.setRunnable(new Runnable(){

            @Override
            public void run() {
                if (EventManager.this.game.getSleeping()) {
                    ((EventManager)EventManager.this).game.dialogueBox.show();
                    ((EventManager)EventManager.this).game.dialogueBox.setText(String.format("You slept for %d hours!\nYou recovered %d energy!", hoursSlept, Math.min(100, hoursSlept * 13)), "fadefromblack");
                    EventManager.this.game.setEnergy(hoursSlept * 13);
                    EventManager.this.game.passTime(secondsSlept);
                    EventManager.this.game.addSleptHours(hoursSlept);
                }
            }
        });
        this.fadeToBlack(setTextAction);
    }

    public void fadeToBlack() {
        this.game.blackScreen.addAction(Actions.fadeIn(3.0f));
    }

    public void fadeToBlack(RunnableAction runnable) {
        this.game.blackScreen.addAction(Actions.sequence((Action)Actions.fadeIn(3.0f), (Action)runnable));
    }

    public void fadeFromBlack() {
        if (this.game.getSleeping()) {
            RunnableAction setTextAction = new RunnableAction();
            setTextAction.setRunnable(new Runnable(){

                @Override
                public void run() {
                    if (EventManager.this.game.getSleeping()) {
                        ((EventManager)EventManager.this).game.dialogueBox.show();
                        ((EventManager)EventManager.this).game.dialogueBox.setText(EventManager.this.game.getWakeUpMessage());
                        EventManager.this.game.setSleeping(false);
                    }
                }
            });
            this.game.blackScreen.addAction(Actions.sequence((Action)Actions.fadeOut(3.0f), (Action)setTextAction));
        } else {
            this.game.blackScreen.addAction(Actions.fadeOut(3.0f));
        }
    }
}

