/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.skloch.game.HustleGame;
import com.skloch.game.MenuScreen;

public class GameOverScreen
implements Screen {
    private HustleGame game;
    Stage gameOverStage;
    Viewport viewport;
    OrthographicCamera camera;

    public GameOverScreen(final HustleGame game, int hoursStudied, int hoursRecreational, int hoursSlept) {
        this.game = game;
        this.gameOverStage = new Stage(new FitViewport(game.WIDTH, game.HEIGHT));
        Gdx.input.setInputProcessor(this.gameOverStage);
        this.camera = new OrthographicCamera();
        this.viewport = new FitViewport(game.WIDTH, (float)game.HEIGHT, this.camera);
        this.camera.setToOrtho(false, game.WIDTH, game.HEIGHT);
        Window gameOverWindow = new Window("", game.skin);
        this.gameOverStage.addActor(gameOverWindow);
        Table gameOverTable = new Table();
        gameOverWindow.add(gameOverTable);
        Label title = new Label("Game Over!", game.skin, "button");
        gameOverTable.add(title).padTop(10.0f);
        gameOverTable.row();
        Table scoresTable = new Table();
        gameOverTable.add(scoresTable).prefHeight(380.0f).prefWidth(450.0f);
        gameOverTable.row();
        scoresTable.add(new Label("Hours Studied", game.skin, "interaction")).padBottom(5.0f);
        scoresTable.row();
        scoresTable.add(new Label(String.valueOf(hoursStudied), game.skin, "button")).padBottom(20.0f);
        scoresTable.row();
        scoresTable.add(new Label("Recreational hours", game.skin, "interaction")).padBottom(5.0f);
        scoresTable.row();
        scoresTable.add(new Label(String.valueOf(hoursRecreational), game.skin, "button")).padBottom(20.0f);
        scoresTable.row();
        scoresTable.add(new Label("Hours Slept", game.skin, "interaction")).padBottom(5.0f);
        scoresTable.row();
        scoresTable.add(new Label(String.valueOf(hoursSlept), game.skin, "button"));
        TextButton exitButton = new TextButton("Main Menu", game.skin);
        gameOverTable.add(exitButton).bottom().width(300.0f).padTop(10.0f);
        exitButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.soundManager.playButton();
                game.soundManager.overworldMusic.stop();
                GameOverScreen.this.dispose();
                game.setScreen(new MenuScreen(game));
            }
        });
        gameOverWindow.pack();
        gameOverWindow.setSize(600.0f, 600.0f);
        gameOverWindow.setX(this.viewport.getWorldWidth() / 2.0f - gameOverWindow.getWidth() / 2.0f);
        gameOverWindow.setY(this.viewport.getWorldHeight() / 2.0f - gameOverWindow.getHeight() / 2.0f);
    }

    @Override
    public void render(float delta) {
        ScreenUtils.clear(0.0f, 0.0f, 0.0f, 1.0f);
        this.game.blueBackground.draw();
        this.gameOverStage.act(delta);
        this.gameOverStage.draw();
        this.camera.update();
    }

    @Override
    public void resize(int width, int height) {
        this.gameOverStage.getViewport().update(width, height);
        this.viewport.update(width, height);
    }

    @Override
    public void show() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }
}

