/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.renderers.OrthogonalTiledMapRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.skloch.game.DialogueBox;
import com.skloch.game.EventManager;
import com.skloch.game.GameObject;
import com.skloch.game.GameOverScreen;
import com.skloch.game.HustleGame;
import com.skloch.game.MenuScreen;
import com.skloch.game.Player;
import com.skloch.game.SettingsScreen;

public class GameScreen
implements Screen {
    final HustleGame game;
    private OrthographicCamera camera;
    private int energy = 100;
    private int hoursStudied;
    private int hoursRecreational;
    private int hoursSlept;
    private float daySeconds = 0.0f;
    private int day = 1;
    private Label timeLabel;
    private Label dayLabel;
    public Player player;
    private Window escapeMenu;
    private Viewport viewport;
    public OrthogonalTiledMapRenderer mapRenderer;
    public Stage uiStage;
    private Label interactionLabel;
    private EventManager eventManager;
    protected InputMultiplexer inputMultiplexer;
    private Table uiTable;
    private Image energyBar;
    public DialogueBox dialogueBox;
    public final Image blackScreen;
    private boolean sleeping = false;

    public GameScreen(HustleGame game, int avatarChoice) {
        this.game = game;
        this.game.gameScreen = this;
        this.eventManager = new EventManager(this);
        this.hoursSlept = 0;
        this.hoursRecreational = 0;
        this.hoursStudied = 0;
        this.camera = new OrthographicCamera();
        this.viewport = new FitViewport(game.WIDTH, (float)game.HEIGHT, this.camera);
        this.camera.setToOrtho(false, game.WIDTH, game.HEIGHT);
        game.shapeRenderer.setProjectionMatrix(this.camera.combined);
        this.uiStage = new Stage(new FitViewport(game.WIDTH, game.HEIGHT));
        this.blackScreen = new Image(new Texture(Gdx.files.internal("Sprites/black_square.png")));
        this.blackScreen.setSize(this.viewport.getWorldWidth(), this.viewport.getWorldHeight());
        this.blackScreen.addAction(Actions.alpha(0.0f));
        this.uiTable = new Table();
        this.uiTable.setSize(game.WIDTH, game.HEIGHT);
        this.uiStage.addActor(this.uiTable);
        this.player = avatarChoice == 1 ? new Player("avatar1") : new Player("avatar2");
        this.interactionLabel = new Label("E - Interact", game.skin, "default");
        this.dialogueBox = new DialogueBox(game.skin);
        this.dialogueBox.setPos((this.viewport.getWorldWidth() - this.dialogueBox.getWidth()) / 2.0f, 15.0f);
        this.dialogueBox.hide();
        Group energyGroup = new Group();
        energyGroup.setDebug(true);
        this.energyBar = new Image(new Texture(Gdx.files.internal("Interface/Energy Bar/green_bar.png")));
        Image energyBarOutline = new Image(new Texture(Gdx.files.internal("Interface/Energy Bar/bar_outline.png")));
        energyBarOutline.setPosition(this.viewport.getWorldWidth() - energyBarOutline.getWidth() - 15.0f, 15.0f);
        this.energyBar.setPosition(energyBarOutline.getX() + 16.0f, energyBarOutline.getY() + 16.0f);
        energyGroup.addActor(this.energyBar);
        energyGroup.addActor(energyBarOutline);
        this.daySeconds = 480.0f;
        Table timeTable = new Table();
        timeTable.setFillParent(true);
        this.timeLabel = new Label(this.formatTime((int)this.daySeconds), game.skin, "time");
        this.dayLabel = new Label(String.format("Day %d", this.day), game.skin, "day");
        timeTable.add(this.timeLabel).uniformX();
        timeTable.row();
        timeTable.add(this.dayLabel).uniformX().left().padTop(2.0f);
        timeTable.top().left().padLeft(10.0f).padTop(10.0f);
        this.uiTable.add(this.interactionLabel).padTop(300.0f);
        this.uiStage.addActor(energyGroup);
        this.uiStage.addActor(timeTable);
        this.uiStage.addActor(this.blackScreen);
        this.uiStage.addActor(this.dialogueBox.getWindow());
        this.uiStage.addActor(this.dialogueBox.getSelectBox().getWindow());
        this.setupEscapeMenu(this.uiStage);
        game.soundManager.playOverworldMusic();
        InputAdapter gameKeyBoardInput = this.makeInputAdapter();
        this.inputMultiplexer = new InputMultiplexer();
        this.inputMultiplexer.addProcessor(gameKeyBoardInput);
        this.inputMultiplexer.addProcessor(this.uiStage);
        Gdx.input.setInputProcessor(this.inputMultiplexer);
        float unitScale = game.mapScale / (float)game.mapSquareSize;
        this.mapRenderer = new OrthogonalTiledMapRenderer(game.map, unitScale);
        TiledMapTileLayer layer0 = (TiledMapTileLayer)game.map.getLayers().get(0);
        this.player.setPos((float)layer0.getWidth() * game.mapScale / 2.0f, (float)layer0.getHeight() * game.mapScale / 2.0f);
        this.camera.position.set(this.player.getCentreX(), this.player.getCentreY(), 0.0f);
        for (int layer : game.objectLayers) {
            MapObjects objects = game.map.getLayers().get(layer).getObjects();
            for (int i = 0; i < objects.getCount(); ++i) {
                MapProperties properties = objects.get(i).getProperties();
                if (properties.get("spawn") != null) {
                    this.player.setPos(((Float)properties.get("x")).floatValue() * unitScale, ((Float)properties.get("y")).floatValue() * unitScale);
                    this.camera.position.set(this.player.getPosAsVec3());
                    continue;
                }
                this.player.addCollidable(new GameObject(properties, unitScale));
            }
        }
        this.player.setBounds(new Rectangle(0.0f, 0.0f, (float)game.mapProperties.get("width", Integer.class).intValue() * game.mapScale, (float)game.mapProperties.get("height", Integer.class).intValue() * game.mapScale));
        game.shapeRenderer.setProjectionMatrix(this.camera.combined);
        this.dialogueBox.show();
        this.dialogueBox.setText(this.getWakeUpMessage());
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        ScreenUtils.clear(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.viewport.apply();
        delta = 0.016667f;
        this.game.soundManager.processTimers(delta);
        if (!this.escapeMenu.isVisible() && !this.sleeping) {
            this.passTime(Gdx.graphics.getDeltaTime());
        }
        this.timeLabel.setText(this.formatTime((int)this.daySeconds));
        if (this.escapeMenu.isVisible() || this.dialogueBox.isVisible() || this.sleeping) {
            this.player.setFrozen(true);
        } else {
            this.player.setFrozen(false);
        }
        this.dialogueBox.scrollText(0.8f);
        this.player.move(delta);
        if (this.player.isMoving()) {
            this.game.soundManager.playFootstep();
        } else {
            this.game.soundManager.footstepBool = false;
        }
        this.mapRenderer.setView(this.camera);
        this.mapRenderer.render(this.game.backgroundLayers);
        this.game.batch.setProjectionMatrix(this.camera.combined);
        this.game.batch.begin();
        this.game.batch.draw(this.player.getCurrentFrame(), this.player.sprite.x, this.player.sprite.y, 0.0f, 0.0f, this.player.sprite.width, this.player.sprite.height, 1.0f, 1.0f, 1.0f);
        this.game.batch.end();
        this.mapRenderer.render(this.game.foregroundLayers);
        this.interactionLabel.setVisible(false);
        if (!this.dialogueBox.isVisible() && !this.escapeMenu.isVisible() && !this.sleeping && this.player.nearObject()) {
            this.interactionLabel.setVisible(true);
            if (this.player.getClosestObject().get("event") != null) {
                this.interactionLabel.setText("E - Interact");
            } else if (this.player.getClosestObject().get("text") != null) {
                this.interactionLabel.setText("E - Read Sign");
            }
        }
        this.uiStage.getViewport().apply();
        this.uiStage.act(delta);
        this.uiStage.draw();
        this.camera.position.slerp(new Vector3(this.player.getCentreX(), this.player.getCentreY(), 0.0f), delta * 9.0f);
        this.camera.update();
    }

    public void setupEscapeMenu(Stage interfaceStage) {
        this.escapeMenu = new Window("", this.game.skin);
        interfaceStage.addActor(this.escapeMenu);
        this.escapeMenu.setModal(true);
        Table escapeTable = new Table();
        escapeTable.setFillParent(true);
        this.escapeMenu.add(escapeTable);
        TextButton resumeButton = new TextButton("Resume", this.game.skin);
        TextButton settingsButton = new TextButton("Settings", this.game.skin);
        TextButton exitButton = new TextButton("Exit", this.game.skin);
        escapeTable.add(resumeButton).pad(60.0f, 80.0f, 10.0f, 80.0f).width(300.0f);
        escapeTable.row();
        escapeTable.add(settingsButton).pad(10.0f, 50.0f, 10.0f, 50.0f).width(300.0f);
        escapeTable.row();
        escapeTable.add(exitButton).pad(10.0f, 50.0f, 60.0f, 50.0f).width(300.0f);
        this.escapeMenu.pack();
        this.escapeMenu.setX(this.viewport.getWorldWidth() / 2.0f - this.escapeMenu.getWidth() / 2.0f);
        this.escapeMenu.setY(this.viewport.getWorldHeight() / 2.0f - this.escapeMenu.getHeight() / 2.0f);
        resumeButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (GameScreen.this.escapeMenu.isVisible()) {
                    GameScreen.this.game.soundManager.playButton();
                    GameScreen.this.game.soundManager.playOverworldMusic();
                    GameScreen.this.escapeMenu.setVisible(false);
                }
            }
        });
        final GameScreen thisScreen = this;
        settingsButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (GameScreen.this.escapeMenu.isVisible()) {
                    GameScreen.this.game.soundManager.playButton();
                    GameScreen.this.game.setScreen(new SettingsScreen(GameScreen.this.game, thisScreen));
                }
            }
        });
        exitButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (GameScreen.this.escapeMenu.isVisible()) {
                    GameScreen.this.game.soundManager.playButton();
                    GameScreen.this.game.soundManager.stopOverworldMusic();
                    GameScreen.this.dispose();
                    GameScreen.this.game.setScreen(new MenuScreen(GameScreen.this.game));
                }
            }
        });
        this.escapeMenu.setVisible(false);
    }

    @Override
    public void resize(int width, int height) {
        this.uiStage.getViewport().update(width, height);
        this.viewport.update(width, height);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
        Gdx.input.setInputProcessor(this.inputMultiplexer);
        Gdx.input.setCursorPosition(Gdx.input.getX(), Gdx.input.getY());
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.uiStage.dispose();
        this.mapRenderer.dispose();
    }

    public void drawHitboxes() {
        this.game.shapeRenderer.setProjectionMatrix(this.camera.combined);
        this.game.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        this.game.shapeRenderer.setColor(1.0f, 0.0f, 0.0f, 1.0f);
        this.game.shapeRenderer.rect(this.player.sprite.x, this.player.sprite.y, this.player.sprite.width, this.player.sprite.height);
        this.game.shapeRenderer.setColor(0.0f, 0.0f, 1.0f, 1.0f);
        this.game.shapeRenderer.rect(this.player.feet.x, this.player.feet.y, this.player.feet.width, this.player.feet.height);
        this.game.shapeRenderer.setColor(0.0f, 1.0f, 1.0f, 1.0f);
        this.game.shapeRenderer.rect(this.player.eventHitbox.x, this.player.eventHitbox.y, this.player.eventHitbox.width, this.player.eventHitbox.height);
        this.game.shapeRenderer.end();
    }

    public void passTime(float delta) {
        this.daySeconds += delta;
        while (this.daySeconds >= 1440.0f) {
            this.daySeconds -= 1440.0f;
            ++this.day;
            this.dayLabel.setText(String.format("Day %s", this.day));
        }
        if (this.day >= 8) {
            this.GameOver();
        }
    }

    public String formatTime(int seconds) {
        int hour = Math.floorDiv(seconds, 60);
        String minutes = String.format("%02d", seconds - hour * 60);
        if (hour == 24 || hour == 0) {
            return String.format("12:%sam", minutes);
        }
        if (hour == 12) {
            return String.format("12:%spm", minutes);
        }
        if (hour > 12) {
            return String.format("%d:%spm", hour - 12, minutes);
        }
        return String.format("%d:%sam", hour, minutes);
    }

    public InputAdapter makeInputAdapter() {
        return new InputAdapter(){

            @Override
            public boolean keyDown(int keycode) {
                if (keycode == 111) {
                    if (GameScreen.this.escapeMenu.isVisible()) {
                        GameScreen.this.game.soundManager.playButton();
                        GameScreen.this.game.soundManager.playOverworldMusic();
                        GameScreen.this.escapeMenu.setVisible(false);
                    } else {
                        GameScreen.this.game.soundManager.playButton();
                        GameScreen.this.escapeMenu.setVisible(true);
                    }
                    return true;
                }
                if (!(keycode != 33 && keycode != 66 && keycode != 62 || GameScreen.this.escapeMenu.isVisible())) {
                    if (GameScreen.this.dialogueBox.isVisible()) {
                        GameScreen.this.dialogueBox.enter(GameScreen.this.eventManager);
                        GameScreen.this.game.soundManager.playButton();
                    } else if (GameScreen.this.player.nearObject() && !GameScreen.this.sleeping) {
                        if (GameScreen.this.player.getClosestObject().get("event") != null) {
                            GameScreen.this.dialogueBox.show();
                            GameScreen.this.dialogueBox.getSelectBox().setOptions(new String[]{"Yes", "No"}, new String[]{(String)GameScreen.this.player.getClosestObject().get("event"), "exit"});
                            if (GameScreen.this.eventManager.hasCustomObjectInteraction((String)GameScreen.this.player.getClosestObject().get("event"))) {
                                GameScreen.this.dialogueBox.setText(GameScreen.this.eventManager.getObjectInteraction((String)GameScreen.this.player.getClosestObject().get("event")));
                            } else {
                                GameScreen.this.dialogueBox.setText("Interact with " + GameScreen.this.player.getClosestObject().get("event") + "?");
                            }
                            GameScreen.this.dialogueBox.show();
                            GameScreen.this.dialogueBox.getSelectBox().show();
                            GameScreen.this.game.soundManager.playDialogueOpen();
                        } else if (GameScreen.this.player.getClosestObject().get("text") != null) {
                            GameScreen.this.dialogueBox.show();
                            GameScreen.this.dialogueBox.setText((String)GameScreen.this.player.getClosestObject().get("text"));
                        }
                    }
                    return true;
                }
                if (GameScreen.this.dialogueBox.isVisible() && GameScreen.this.dialogueBox.getSelectBox().isVisible() && !GameScreen.this.escapeMenu.isVisible()) {
                    if (keycode == 51 || keycode == 19) {
                        GameScreen.this.dialogueBox.getSelectBox().choiceUp();
                    } else if (keycode == 47 || keycode == 20) {
                        GameScreen.this.dialogueBox.getSelectBox().choiceDown();
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public void setEnergy(int energy) {
        this.energy = energy;
        if (this.energy > 100) {
            this.energy = 100;
        }
        this.energyBar.setScaleY((float)this.energy / 100.0f);
    }

    public int getEnergy() {
        return this.energy;
    }

    public void decreaseEnergy(int energy) {
        this.energy -= energy;
        if (this.energy < 0) {
            this.energy = 0;
        }
        this.energyBar.setScaleY((float)this.energy / 100.0f);
    }

    public void addStudyHours(int hours) {
        this.hoursStudied += hours;
    }

    public void addRecreationalHours(int hours) {
        this.hoursRecreational += hours;
    }

    public String getMeal() {
        int hours = Math.floorDiv((int)this.daySeconds, 60);
        if (hours >= 7 && hours <= 10) {
            return "breakfast";
        }
        if (hours > 10 && hours <= 16) {
            return "lunch";
        }
        if (hours > 16 && hours <= 21) {
            return "dinner";
        }
        return "food";
    }

    public String getWakeUpMessage() {
        int daysLeft = 8 - this.day;
        if (daysLeft != 1) {
            return String.format("You have %d days left until your exam!\nRemember to eat, study and have fun, but don't overwork yourself!", daysLeft);
        }
        return "Your exam is tomorrow! I hope you've been studying! Remember not to overwork yourself and get enough sleep!";
    }

    public void setSleeping(boolean sleeping) {
        this.sleeping = sleeping;
    }

    public boolean getSleeping() {
        return this.sleeping;
    }

    public void addSleptHours(int hours) {
        this.hoursSlept += hours;
    }

    public float getSeconds() {
        return this.daySeconds;
    }

    public void GameOver() {
        this.game.setScreen(new GameOverScreen(this.game, this.hoursStudied, this.hoursRecreational, this.hoursSlept));
    }
}

