/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TmxMapLoader;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.skloch.game.GameScreen;
import com.skloch.game.MenuScreen;
import com.skloch.game.SoundManager;

public class HustleGame
extends Game {
    public SpriteBatch batch;
    public int WIDTH;
    public int HEIGHT;
    public Skin skin;
    public TiledMap map;
    public String credits;
    public String tutorialText;
    public GameScreen gameScreen;
    public MenuScreen menuScreen;
    public ShapeRenderer shapeRenderer;
    public SoundManager soundManager;
    public Stage blueBackground;
    public int[] backgroundLayers;
    public int[] foregroundLayers;
    public int[] objectLayers;
    public int mapSquareSize;
    public float mapScale;
    public MapProperties mapProperties;

    public HustleGame(int width, int height) {
        this.WIDTH = width;
        this.HEIGHT = height;
    }

    @Override
    public void create() {
        this.batch = new SpriteBatch();
        this.skin = new Skin(Gdx.files.internal("Interface/BlockyInterface.json"));
        this.map = new TmxMapLoader().load("East Campus/east_campus.tmx");
        this.mapProperties = this.map.getProperties();
        this.backgroundLayers = new int[]{0, 1, 2, 3, 4, 5, 6};
        this.foregroundLayers = new int[]{7};
        this.objectLayers = new int[]{8};
        this.mapSquareSize = this.mapProperties.get("tilewidth", Integer.class);
        this.mapScale = 70.0f;
        this.shapeRenderer = new ShapeRenderer();
        this.soundManager = new SoundManager();
        Image blueImage = new Image(new Texture(Gdx.files.internal("Sprites/white_square.png")));
        blueImage.setColor(0.53f, 0.81f, 0.92f, 1.0f);
        blueImage.setName("blue image");
        this.blueBackground = new Stage();
        this.blueBackground.addActor(blueImage);
        this.credits = this.readTextFile("Text/credits.txt");
        this.tutorialText = this.readTextFile("Text/tutorial_text.txt");
        this.setScreen(new MenuScreen(this));
    }

    @Override
    public void render() {
        super.render();
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        this.blueBackground.dispose();
        this.skin.dispose();
        this.map.dispose();
        this.shapeRenderer.dispose();
        this.soundManager.dispose();
    }

    public String readTextFile(String filepath) {
        FileHandle file = Gdx.files.internal(filepath);
        if (!file.exists()) {
            System.out.println("WARNING: Couldn't load file " + filepath);
            return "Couldn't load " + filepath;
        }
        return file.readString();
    }
}

