/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.skloch.game.CreditScreen;
import com.skloch.game.GameScreen;
import com.skloch.game.HustleGame;
import com.skloch.game.SettingsScreen;

public class MenuScreen
implements Screen {
    final HustleGame game;
    private Stage menuStage;
    OrthographicCamera camera;
    private Viewport viewport;
    private Image titleImage;

    public MenuScreen(final HustleGame game) {
        this.game = game;
        this.game.menuScreen = this;
        this.menuStage = new Stage(new FitViewport(game.WIDTH, game.HEIGHT));
        Gdx.input.setInputProcessor(this.menuStage);
        this.camera = new OrthographicCamera();
        this.viewport = new FitViewport(game.WIDTH, (float)game.HEIGHT, this.camera);
        this.camera.setToOrtho(false, game.WIDTH, game.HEIGHT);
        ((Actor)game.blueBackground.getRoot().findActor("blue image")).setSize(this.viewport.getWorldWidth(), this.viewport.getWorldHeight());
        this.titleImage = new Image(new Texture(Gdx.files.internal("title.png")));
        this.titleImage.setPosition(this.viewport.getWorldWidth() / 2.0f - this.titleImage.getWidth() / 2.0f, 500.0f);
        this.menuStage.addActor(this.titleImage);
        game.soundManager.playMenuMusic();
        Table avatarSelectTable = this.makeAvatarSelectTable();
        this.menuStage.addActor(avatarSelectTable);
        avatarSelectTable.setVisible(false);
        final Window tutorialWindow = this.makeTutorialWindow(avatarSelectTable);
        this.menuStage.addActor(tutorialWindow);
        tutorialWindow.setVisible(false);
        final Table buttonTable = new Table();
        buttonTable.setFillParent(true);
        this.menuStage.addActor(buttonTable);
        TextButton startButton = new TextButton("New Game", game.skin);
        TextButton settingsButton = new TextButton("Settings", game.skin);
        TextButton creditsButton = new TextButton("Credits", game.skin);
        TextButton exitButton = new TextButton("Exit", game.skin);
        int buttonWidth = 340;
        buttonTable.add(startButton).uniformX().width(buttonWidth).padBottom(10.0f).padTop(280.0f);
        buttonTable.row();
        buttonTable.add(settingsButton).uniformX().width(buttonWidth).padBottom(10.0f);
        buttonTable.row();
        buttonTable.add(creditsButton).uniformX().width(buttonWidth).padBottom(30.0f);
        buttonTable.row();
        buttonTable.add(exitButton).uniformX().width(buttonWidth);
        buttonTable.top();
        startButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.soundManager.playButton();
                buttonTable.setVisible(false);
                MenuScreen.this.titleImage.setVisible(false);
                tutorialWindow.setVisible(true);
            }
        });
        final MenuScreen thisScreen = this;
        settingsButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.soundManager.playButton();
                game.setScreen(new SettingsScreen(game, thisScreen));
            }
        });
        creditsButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.soundManager.playButton();
                game.setScreen(new CreditScreen(game, thisScreen));
            }
        });
        exitButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.soundManager.playButton();
                game.dispose();
                MenuScreen.this.dispose();
                Gdx.app.exit();
            }
        });
        game.batch.setProjectionMatrix(this.camera.combined);
    }

    @Override
    public void render(float delta) {
        ScreenUtils.clear(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.camera.update();
        this.game.blueBackground.draw();
        this.menuStage.setViewport(this.viewport);
        this.menuStage.act(Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f));
        this.menuStage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height);
        this.menuStage.getViewport().update(width, height);
    }

    @Override
    public void show() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
        Gdx.input.setInputProcessor(this.menuStage);
        Gdx.input.setCursorPosition(Gdx.input.getX(), Gdx.input.getY());
    }

    @Override
    public void dispose() {
        this.menuStage.dispose();
    }

    public Window makeTutorialWindow(final Table nextTable) {
        final Window tutWindow = new Window("", this.game.skin);
        Table tutTable = new Table();
        tutWindow.add(tutTable).prefHeight(600.0f).prefWidth(780.0f);
        Label title = new Label("How to play", this.game.skin, "button");
        tutTable.add(title).padTop(10.0f);
        tutTable.row();
        Table scrollTable = new Table();
        ScrollPane scrollWindow = new ScrollPane((Actor)scrollTable, this.game.skin);
        scrollWindow.setFadeScrollBars(false);
        tutTable.add(scrollWindow).padTop(20.0f).height(350.0f).width(870.0f);
        tutTable.row();
        Label text = new Label(this.game.tutorialText, this.game.skin, "interaction");
        text.setWrap(true);
        scrollTable.add(text).width(820.0f).padLeft(20.0f);
        TextButton continueButton = new TextButton("Continue", this.game.skin);
        tutTable.add(continueButton).bottom().width(300.0f).padTop(10.0f);
        tutWindow.pack();
        tutWindow.setSize(900.0f, 600.0f);
        tutWindow.setX(this.viewport.getWorldWidth() / 2.0f - tutWindow.getWidth() / 2.0f);
        tutWindow.setY(this.viewport.getWorldHeight() / 2.0f - tutWindow.getHeight() / 2.0f);
        continueButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MenuScreen.this.game.soundManager.playButton();
                tutWindow.setVisible(false);
                nextTable.setVisible(true);
            }
        });
        return tutWindow;
    }

    public Table makeAvatarSelectTable() {
        Table table = new Table();
        table.setFillParent(true);
        table.top();
        Label title = new Label("Select your avatar", this.game.skin, "button");
        table.add(title).padBottom(120.0f).padTop(80.0f);
        table.row();
        Table buttonTable = new Table();
        table.add(buttonTable).width(600.0f);
        ImageButton choice1 = new ImageButton(this.game.skin, "avatar1");
        buttonTable.add(choice1).left().expandX();
        ImageButton choice2 = new ImageButton(this.game.skin, "avatar2");
        buttonTable.add(choice2).right().expandX();
        choice1.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MenuScreen.this.game.soundManager.playButton();
                MenuScreen.this.game.setScreen(new GameScreen(MenuScreen.this.game, 1));
                MenuScreen.this.game.soundManager.stopMenuMusic();
                MenuScreen.this.dispose();
            }
        });
        choice2.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MenuScreen.this.game.soundManager.playButton();
                MenuScreen.this.game.setScreen(new GameScreen(MenuScreen.this.game, 2));
                MenuScreen.this.game.soundManager.stopMenuMusic();
                MenuScreen.this.dispose();
            }
        });
        return table;
    }
}

