/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.skloch.game.SoundManager;

public class OptionDialogue {
    private Window window;
    public Label questionLabel;
    private Label leftArrow;
    private Label rightArrow;
    boolean visible = false;
    boolean choice = false;
    private SoundManager soundManager;

    public OptionDialogue(String question, int width, Skin skin, SoundManager soundManager) {
        this.soundManager = soundManager;
        this.window = new Window("", skin);
        this.window.setModal(true);
        this.window.setModal(true);
        Table dialogueTable = new Table();
        this.questionLabel = new Label("Interact", skin, "interaction");
        this.questionLabel.setWrap(true);
        this.leftArrow = new Label(">", skin, "interaction");
        this.rightArrow = new Label(">", skin, "interaction");
        Label option1Label = new Label("Yes", skin, "interaction");
        Label option2Label = new Label("No", skin, "interaction");
        this.questionLabel.setAlignment(1);
        dialogueTable.add(this.questionLabel).top().colspan(4).fillX();
        dialogueTable.row().pad(0.0f, 0.0f, 0.0f, 0.0f);
        dialogueTable.add(this.leftArrow).right().padLeft(width - 290);
        dialogueTable.add(option1Label).left().padLeft(10.0f).padRight(30.0f);
        dialogueTable.add(this.rightArrow).right();
        dialogueTable.add(option2Label).left().padLeft(10.0f).padRight(width - 290);
        this.window.add(dialogueTable).fillX().left();
        this.window.pack();
        this.updateArrow();
        this.setVisible(false);
        this.setWidth(width);
    }

    public Window getWindow() {
        return this.window;
    }

    public void setPos(float x, float y) {
        this.window.setX(x);
        this.window.setY(y);
    }

    public void setWidth(int x) {
        this.window.setWidth(x);
        this.window.setX((float)Gdx.graphics.getWidth() / 2.0f - this.window.getWidth() / 2.0f);
        this.window.setY((float)Gdx.graphics.getHeight() / 2.0f - this.window.getHeight() / 2.0f - 150.0f);
    }

    public void setQuestionText(String text) {
        this.questionLabel.setText(text);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.window.setVisible(visible);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean getChoice() {
        return this.choice;
    }

    public void setChoice(Boolean choice) {
        this.choice = choice;
        this.updateArrow();
    }

    public void act(int keycode) {
        if (this.choice && (keycode == 32 || keycode == 22)) {
            this.choice = false;
        } else if (!(this.choice || keycode != 29 && keycode != 21)) {
            this.choice = true;
        }
        this.updateArrow();
        this.soundManager.playDialogueOption();
    }

    private void updateArrow() {
        if (this.choice) {
            this.rightArrow.setVisible(false);
            this.leftArrow.setVisible(true);
        } else {
            this.rightArrow.setVisible(true);
            this.leftArrow.setVisible(false);
        }
    }
}

