/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.utils.Disposable;

public class SoundManager
implements Disposable {
    public Music overworldMusic = Gdx.audio.newMusic(Gdx.files.internal("Music/OverworldMusic.mp3"));
    public Music menuMusic;
    private Sound footstep1;
    private Sound footstep2;
    public boolean footstepBool;
    private float footstepTimer;
    private float sfxVolume = 0.8f;
    private float musicVolume = 0.8f;
    private Sound pauseSound;
    private Sound dialogueOpenSound;
    private Sound dialogueOptionSound;
    private Sound buttonSound;

    public SoundManager() {
        this.overworldMusic.setLooping(true);
        this.menuMusic = Gdx.audio.newMusic(Gdx.files.internal("Music/Streetlights.ogg"));
        this.menuMusic.setLooping(true);
        this.footstep1 = Gdx.audio.newSound(Gdx.files.internal("Sounds/footstep1 grass.ogg"));
        this.footstep2 = Gdx.audio.newSound(Gdx.files.internal("Sounds/footstep2 grass.ogg"));
        this.pauseSound = Gdx.audio.newSound(Gdx.files.internal("Sounds/Pause01.wav"));
        this.dialogueOpenSound = Gdx.audio.newSound(Gdx.files.internal("Sounds/DialogueOpen.wav"));
        this.dialogueOptionSound = Gdx.audio.newSound(Gdx.files.internal("Sounds/DialogueOption.wav"));
        this.buttonSound = Gdx.audio.newSound(Gdx.files.internal("Sounds/Button.wav"));
    }

    public void setMusicVolume(float volume) {
        this.musicVolume = volume;
        this.overworldMusic.setVolume(this.musicVolume);
        this.menuMusic.setVolume(this.musicVolume);
    }

    public void setSfxVolume(float volume) {
        this.sfxVolume = volume;
    }

    public void playPauseSound() {
        this.pauseSound.play(this.sfxVolume);
    }

    public void playDialogueOpen() {
        this.dialogueOpenSound.play(this.sfxVolume);
    }

    public void playDialogueOption() {
        this.dialogueOptionSound.play(this.sfxVolume);
    }

    public void playButton() {
        this.buttonSound.play(this.sfxVolume);
    }

    public void playOverworldMusic() {
        this.overworldMusic.play();
    }

    public void stopOverworldMusic() {
        this.overworldMusic.stop();
    }

    public void playMenuMusic() {
        this.menuMusic.play();
    }

    public void stopMenuMusic() {
        this.menuMusic.stop();
    }

    public void pauseOverworldMusic() {
        this.overworldMusic.pause();
    }

    public float getMusicVolume() {
        return this.musicVolume;
    }

    public float getSfxVolume() {
        return this.sfxVolume;
    }

    public void processTimers(float delta) {
        this.footstepTimer -= delta;
        if (this.footstepTimer < 0.0f) {
            this.footstepTimer = 0.0f;
        }
    }

    public void playFootstep() {
        if (this.footstepTimer <= 0.0f) {
            this.footstepTimer = 0.5f;
            if (!this.footstepBool) {
                this.footstep1.play(this.sfxVolume);
                this.footstepBool = true;
            } else {
                this.footstep2.play(this.sfxVolume);
                this.footstepBool = false;
            }
        }
    }

    @Override
    public void dispose() {
        this.overworldMusic.dispose();
        this.menuMusic.dispose();
        this.footstep1.dispose();
        this.footstep2.dispose();
        this.pauseSound.dispose();
        this.dialogueOpenSound.dispose();
        this.dialogueOptionSound.dispose();
    }
}

